// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include "Tscmsg.h"
#include "mpilib.h"

extern DWORD	dwCountDwords;
extern DWORD	dwCountBits;
extern DWORD	dwCountBytes;
extern BYTE		Temp2;
extern BYTE		Temp3;
extern BYTE		Temp5;
extern BOOL		bCancelOperation;
extern BOOL		bTestingPrimeP;
extern DWORD	dwFermatNumber;

// Fast sieve tests a suspected number for being prime. After a
// suspected number passes the fast sieve it should be further
// tested via Fermat's theorem. Returns TRUE if number passes
// the fast sieve, else FALSE.
//..............................................................
BOOL FastSieve(DWORD dwPDelta, LPBYTE lpPrimeTable, LPBYTE lpRemaindersTable)
{
	BOOL	bResult;

	__asm
	{
		mov		ecx,PRIMES_IN_TABLE
		mov		esi,lpPrimeTable
		mov		edi,lpRemaindersTable

		// We start at position 1, not 0, in the tables.
		//..............................................
		add		esi,UNIT_BYTES
		add		edi,UNIT_BYTES
		dec		ecx

		align	4
	L1:	xor		edx,edx
		mov		eax,dwPDelta
		add		eax,dword ptr [edi]
		mov		ebx,dword ptr [esi]
		div		ebx

		// If the remainder is 0, the number is not a prime candidate.
		//............................................................
		cmp		edx,0
		jnz		L2
		mov		bResult,0
		jmp		L3
	L2:	add		esi,UNIT_BYTES
		add		edi,UNIT_BYTES
		dec		ecx
		jnz		L1
		mov		bResult,1
	L3:
	}
	return(bResult);
}

// Fill the prime table with small 16 bit prime numbers to use
// in the fastsieve function.
//............................................................
BOOL FillPrimeTable(LPBYTE lpPrimeTable, DWORD dwPrimesRequired)
{
	DWORD dwTestNumber;

	__asm
	{
		// Set the first two entries in the prime table to 2 and 3.
		//.........................................................
		mov		edi,lpPrimeTable
		mov		eax,2
		stosd
		inc		eax
		stosd
		mov		ecx,dwPrimesRequired
		sub		ecx,2
		mov		dwTestNumber,5		// Starting test number

		// Find our prime numbers.
		//........................
	L1:	push	ecx
		pushad
	}
	// See if we want to quit.
	//........................
	CheckForMessages();
	if (bCancelOperation)
	{
		__asm
		{
			popad
			pop		ecx
		}
		return(FALSE);
	}

	__asm
	{
		popad
	L2:	mov		ecx,1			// ecx = divisor
	L3: xor		edx,edx
		mov		eax,dwTestNumber
		add		ecx,2
		div		ecx

		// If remainder is 0, not prime. Try next text number.
		//....................................................
		cmp		edx,0			
		jne		L4
		add		dwTestNumber,2
		jmp		L2

		// If divisor greater than quotient, number is prime.
		// Otherwise, continue testing.
		//...................................................
	L4:	cmp		ecx,eax
		ja		L5
		jmp		L3

		// The number is prime. Store it in the prime table.
		//..................................................
	L5:	mov		eax,dwTestNumber
		stosd
		add		dwTestNumber,2
		pop		ecx
		dec		ecx
		jnz		L1
	}
	return(TRUE);
}

// FermatTest conducts 4 tests on our suspected prime number.
// All temporary variables must accomodate the largesty expected
// numbers. Once a candidate number has passed 4 Fermat tests it
// is considered prime.
//
// Calculates: If ((X^(P-1)) MOD P) != 1 the number is not prime.
//
// Uses: Temp2, Temp3, and Temp5.
//
// Returns: FALSE if number is not prime, and TRUE is it is.
//...............................................................
BOOL FermatTest(LPBYTE lpPrimeCandidate, LPBYTE lpPrimeTable, DWORD dwPrimeBytes)
{
	DWORD	dwTestNumber;
	BOOL	bResult = TRUE;
	int		iResult;

	// Use Temp3 to hold (Prime Candidate -1).
	//........................................
	ZeroMemory(&Temp3,(MAX_MOD_SLOP*2));
	CopyMemory(&Temp3,lpPrimeCandidate,dwPrimeBytes);
	MpDecDW(&Temp3,MAX_PRIME_DWORD);

	// Conduct the 4 Fermat Tests.
	//............................
	dwTestNumber = 0;
	while(dwTestNumber < 4)
	{
		// Use Temp2 to hold a small prime number from the
		// prime number table.
		//................................................
		ZeroMemory(&Temp2,(MAX_MOD_SLOP*2));
		__asm
		{
			mov		ecx,dwTestNumber
			mov		edi,lpPrimeTable
			mov		eax,dword ptr [edi][ecx*4]
			mov		edi,offset Temp2
			mov		dword ptr [edi],eax
		}
		// Use Temp5 to return the results in.
		//....................................
	
		iResult = mp_modexp((unitptr)&Temp5,(unitptr)&Temp2,(unitptr)&Temp3,
						   (unitptr)lpPrimeCandidate);

		// See if we want to quit.
		//........................
		EmptyTheMessageQue();
		if (bCancelOperation)
		{
			bResult = FALSE;
			break;
		}

		if (iResult < 0)
		{
			bResult = FALSE;
		}
		// Count the bits in the remainder. It will be 1 if the
		// remainder equals 1.
		//.....................................................
		CountBBD(&Temp5,dwPrimeBytes);
		if (dwCountBits != 1)
		{
			bResult = FALSE;
			break;
		}
		// Update progess in the screen. To be filled in later.
		//.....................................................
		dwFermatNumber ++;

		if (bTestingPrimeP)
		{
			PrimePFermatProgress();
		}
		else
		{
			PrimeQFermatProgress();
		}
		dwTestNumber++;
	}
	return(bResult);
}

